/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.client.pi;

import com.ibm.hsc.cim.client.pi.PIHSCCECCIMClient;
import com.ibm.hsc.client.PICodHistLogEntryDataBean;
import com.ibm.hsc.client.PICodKeyDataBean;
import com.ibm.hsc.client.PICodMemInfoDataBean;
import com.ibm.hsc.client.PICodOrderInfoDataBean;
import com.ibm.hsc.client.PICodProcInfoDataBean;
import com.ibm.hsc.client.PIOnoffCodBillingInfoDataBean;
import com.ibm.hsc.client.PISharedProcPoolUtilizationDataBean;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.exceptions.PIHscExceptionUtils;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.websm.diagnostics.IDebug;
import java.io.FileInputStream;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class PICodActions {
    private static final String MOF_PROCESSOR_UNITS = "ProcessorUnits";
    private static final String MOF_HOURS_TO_USE_PROCS = "HoursToUseProcs";
    private static final String MOF_MEMORY_UNITS = "MemoryUnits";
    private static final String MOF_HOURS_TO_USE_MEM = "HoursToUseMem";
    private static final String MOF_RESOURCE_TYPE = "ResourceType";
    private static final String MOF_COD_TYPE = "CodType";
    private static final String MOF_CONFIRMATION_PARM = "ConfirmationParm";
    private static final String MOF_CONFIRMATION_ID = "ConfirmationId";
    private static final String MOF_COD_KEY = "CodKey";
    private static final String MOF_COD_RECOVERY_COMPLETE_VALUE = "CodRecoveryCompleteValue";
    public static final String ONOFF_PROC_INCREMENT = "OnoffProcIncrement";
    public static final String METERED_PROC_INCREMENT = "MeteredProcIncrement";
    public static final String ONOFF_MEM_INCREMENT = "OnoffMemIncrement";
    private PIHSCCECCIMClient mCecClient;
    private CIMObjectPath mObjectPath;
    private static PICodActions mInst;
    private String mCecName;
    private String mHostName;
    private static final String TIMEOUT_PROPS_FILE = "/opt/hsc/data/hmc.properties";
    private static final String TIMEOUT_KEY = "CodKeyAsyncTimeoutInSec";
    private static final int DEFAULT_TIMEOUT_SEC = 300;
    private static final int COD_KEY_ASYNC_TIMEOUT_SEC;

    protected PICodActions(PIHSCCECCIMClient pIHSCCECCIMClient) {
        this.mCecClient = pIHSCCECCIMClient;
        this.mHostName = pIHSCCECCIMClient.getHostName();
        this.mObjectPath = pIHSCCECCIMClient.getObjectPath();
        this.mCecName = pIHSCCECCIMClient.getIntName();
    }

    private String getCecName() {
        return this.mCecName;
    }

    public static PICodActions getInstance(PIHSCCECCIMClient pIHSCCECCIMClient) {
        if (null == mInst) {
            mInst = new PICodActions(pIHSCCECCIMClient);
        } else if (!pIHSCCECCIMClient.getIntName().equals(mInst.getCecName())) {
            mInst = new PICodActions(pIHSCCECCIMClient);
        }
        return mInst;
    }

    public PICodProcInfoDataBean getCodProcInfoDataBean() throws PIHscClientException {
        return this.getCodProcInfoDataBean(PICodProcInfoDataBean.ALL_KEYS);
    }

    public PICodProcInfoDataBean getCodProcInfoDataBean(String[] stringArray) throws PIHscClientException {
        HashSet<String> hashSet = new HashSet<String>(stringArray.length * 2);
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        boolean bl = false;
        PICodProcInfoDataBean pICodProcInfoDataBean = new PICodProcInfoDataBean();
        try {
            int n;
            Object object;
            UnsignedInt32 unsignedInt32;
            UnsignedInt32 unsignedInt322;
            Vector vector;
            Vector vector2;
            if (hashSet.contains("installed_procs") || hashSet.contains("deconfig_procs") || hashSet.contains("perm_procs")) {
                vector2 = new Vector();
                vector = new Vector();
                PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetCodProcessorInfo", vector2, vector);
                if (vector.elementAt(0) instanceof CIMValue) {
                    unsignedInt322 = (UnsignedInt32)((CIMValue)vector.elementAt(0)).getValue();
                    unsignedInt32 = (UnsignedInt32)((CIMValue)vector.elementAt(1)).getValue();
                    object = (UnsignedInt32)((CIMValue)vector.elementAt(2)).getValue();
                } else {
                    unsignedInt322 = (UnsignedInt32)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                    unsignedInt32 = (UnsignedInt32)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                    object = (UnsignedInt32)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                }
                pICodProcInfoDataBean.m_installedProcs = new UnsignedInt32(unsignedInt322.longValue() / 100L);
                pICodProcInfoDataBean.m_permProcs = new UnsignedInt32(unsignedInt32.longValue() / 100L);
                pICodProcInfoDataBean.m_deconfigProcs = new UnsignedInt32(object.longValue() / 100L);
            }
            if (hashSet.contains("activated_onoff_procs") || hashSet.contains("onoff_proc_days_avail") || hashSet.contains("onoff_request_proc_days_left") || hashSet.contains("onoff_proc_day_hours_left") || hashSet.contains("proc_onoff_state") || hashSet.contains("avail_procs_for_onoff") || hashSet.contains("unreturned_onoff_procs")) {
                vector2 = new Vector();
                vector = new Vector();
                PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetOnoffCodProcessorInfo", vector2, vector);
                if (vector.elementAt(0) instanceof CIMValue) {
                    unsignedInt322 = (UnsignedInt32)((CIMValue)vector.elementAt(0)).getValue();
                    unsignedInt32 = (UnsignedInt32)((CIMValue)vector.elementAt(1)).getValue();
                    object = (UnsignedInt32)((CIMValue)vector.elementAt(2)).getValue();
                    pICodProcInfoDataBean.m_onoffProcDaysAvail = (UnsignedInt16)((CIMValue)vector.elementAt(3)).getValue();
                    pICodProcInfoDataBean.m_onoffRequestProcDaysLeft = (UnsignedInt16)((CIMValue)vector.elementAt(4)).getValue();
                    pICodProcInfoDataBean.m_onoffProcHoursLeft = (UnsignedInt8)((CIMValue)vector.elementAt(5)).getValue();
                    pICodProcInfoDataBean.m_onoffProcState = (UnsignedInt8)((CIMValue)vector.elementAt(6)).getValue();
                } else {
                    unsignedInt322 = (UnsignedInt32)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                    unsignedInt32 = (UnsignedInt32)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                    object = (UnsignedInt32)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                    pICodProcInfoDataBean.m_onoffProcDaysAvail = (UnsignedInt16)((CIMProperty)vector.elementAt(3)).getValue().getValue();
                    pICodProcInfoDataBean.m_onoffRequestProcDaysLeft = (UnsignedInt16)((CIMProperty)vector.elementAt(4)).getValue().getValue();
                    pICodProcInfoDataBean.m_onoffProcHoursLeft = (UnsignedInt8)((CIMProperty)vector.elementAt(5)).getValue().getValue();
                    pICodProcInfoDataBean.m_onoffProcState = (UnsignedInt8)((CIMProperty)vector.elementAt(6)).getValue().getValue();
                }
                pICodProcInfoDataBean.m_onoffProcsActivated = new UnsignedInt32(unsignedInt322.longValue() / 100L);
                pICodProcInfoDataBean.m_onoffProcsAvail = new UnsignedInt32(unsignedInt32.longValue() / 100L);
                pICodProcInfoDataBean.m_onoffProcsUnreturned = new UnsignedInt32(object.longValue() / 100L);
            }
            if (hashSet.contains("activated_reserve_procs") || hashSet.contains("reserve_procs_hours_left") || hashSet.contains("reserve_prepaid_proc_days_left") || hashSet.contains("proc_reserve_state") || hashSet.contains("avail_procs_for_reserve")) {
                vector2 = new Vector();
                vector = new Vector();
                PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetMeteredCodProcessorInfo", vector2, vector);
                if (vector.elementAt(0) instanceof CIMValue) {
                    unsignedInt322 = (UnsignedInt32)((CIMValue)vector.elementAt(0)).getValue();
                    unsignedInt32 = (UnsignedInt32)((CIMValue)vector.elementAt(1)).getValue();
                    pICodProcInfoDataBean.m_meteredPrepaidProcDaysLeft = (UnsignedInt16)((CIMValue)vector.elementAt(2)).getValue();
                    pICodProcInfoDataBean.m_meteredProcState = (UnsignedInt8)((CIMValue)vector.elementAt(3)).getValue();
                    object = (Vector)((CIMValue)vector.elementAt(4)).getValue();
                } else {
                    unsignedInt322 = (UnsignedInt32)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                    unsignedInt32 = (UnsignedInt32)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                    pICodProcInfoDataBean.m_meteredPrepaidProcDaysLeft = (UnsignedInt16)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                    pICodProcInfoDataBean.m_meteredProcState = (UnsignedInt8)((CIMProperty)vector.elementAt(3)).getValue().getValue();
                    object = (Vector)((CIMProperty)vector.elementAt(4)).getValue().getValue();
                }
                pICodProcInfoDataBean.m_meteredProcsActivated = new UnsignedInt32(unsignedInt322.longValue() / 100L);
                pICodProcInfoDataBean.m_meteredProcsAvail = new UnsignedInt32(unsignedInt32.longValue() / 100L);
                pICodProcInfoDataBean.m_meteredProcsHoursLeft = new UnsignedInt16[((Vector)object).size()];
                for (n = 0; n < ((Vector)object).size(); ++n) {
                    int n2 = ((UnsignedInt16)((Vector)object).get(n)).intValue();
                    pICodProcInfoDataBean.m_meteredProcsHoursLeft[n] = new UnsignedInt16(n2 / 60);
                }
            }
            if (hashSet.contains("activated_trial_procs") || hashSet.contains("unreturned_trial_procs") || hashSet.contains("proc_trial_state") || hashSet.contains("proc_trial_days_left") || hashSet.contains("proc_trial_hours_left")) {
                vector2 = new Vector();
                vector = new Vector();
                PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetTrialCodProcessorInfo", vector2, vector);
                if (vector.elementAt(0) instanceof CIMValue) {
                    unsignedInt322 = (UnsignedInt32)((CIMValue)vector.elementAt(0)).getValue();
                    unsignedInt32 = (UnsignedInt32)((CIMValue)vector.elementAt(1)).getValue();
                    object = (UnsignedInt16)((CIMValue)vector.elementAt(2)).getValue();
                    pICodProcInfoDataBean.m_trialProcState = (UnsignedInt8)((CIMValue)vector.elementAt(3)).getValue();
                } else {
                    unsignedInt322 = (UnsignedInt32)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                    unsignedInt32 = (UnsignedInt32)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                    object = (UnsignedInt16)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                    pICodProcInfoDataBean.m_trialProcState = (UnsignedInt8)((CIMProperty)vector.elementAt(3)).getValue().getValue();
                }
                pICodProcInfoDataBean.m_trialProcsActivated = new UnsignedInt32(unsignedInt322.longValue() / 100L);
                pICodProcInfoDataBean.m_trialProcsUnreturned = new UnsignedInt32(unsignedInt32.longValue() / 100L);
                n = object.intValue();
                pICodProcInfoDataBean.m_trialProcsDaysLeft = new UnsignedInt16(n / 24);
                pICodProcInfoDataBean.m_trialProcsHoursLeft = new UnsignedInt16(n % 24);
            }
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return pICodProcInfoDataBean;
    }

    public PICodMemInfoDataBean getCodMemInfoDataBean() throws PIHscClientException {
        return this.getCodMemInfoDataBean(PICodMemInfoDataBean.ALL_KEYS);
    }

    public PICodMemInfoDataBean getCodMemInfoDataBean(String[] stringArray) throws PIHscClientException {
        HashSet<String> hashSet = new HashSet<String>(stringArray.length * 2);
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        PICodMemInfoDataBean pICodMemInfoDataBean = new PICodMemInfoDataBean();
        try {
            Vector vector;
            Vector vector2;
            if (hashSet.contains("installed_mem") || hashSet.contains("deconfig_mem") || hashSet.contains("perm_mem")) {
                vector2 = new Vector();
                vector = new Vector();
                PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetCodMemoryInfo", vector2, vector);
                if (vector.elementAt(0) instanceof CIMValue) {
                    pICodMemInfoDataBean.m_installedMem = (UnsignedInt32)((CIMValue)vector.elementAt(0)).getValue();
                    pICodMemInfoDataBean.m_permMem = (UnsignedInt32)((CIMValue)vector.elementAt(1)).getValue();
                    pICodMemInfoDataBean.m_deconfigMem = (UnsignedInt32)((CIMValue)vector.elementAt(2)).getValue();
                } else {
                    pICodMemInfoDataBean.m_installedMem = (UnsignedInt32)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                    pICodMemInfoDataBean.m_permMem = (UnsignedInt32)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                    pICodMemInfoDataBean.m_deconfigMem = (UnsignedInt32)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                }
            }
            if (hashSet.contains("activated_onoff_mem") || hashSet.contains("avail_mem_for_onoff") || hashSet.contains("onoff_mem_days_avail") || hashSet.contains("onoff_request_mem_days_left") || hashSet.contains("onoff_mem_day_hours_left") || hashSet.contains("mem_onoff_state") || hashSet.contains("unreturned_onoff_mem") || hashSet.contains("onoff_mem_unit")) {
                vector2 = new Vector();
                vector = new Vector();
                PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetOnoffCodMemoryInfo", vector2, vector);
                if (vector.elementAt(0) instanceof CIMValue) {
                    pICodMemInfoDataBean.m_onoffMemActivated = (UnsignedInt32)((CIMValue)vector.elementAt(0)).getValue();
                    pICodMemInfoDataBean.m_onoffMemAvail = (UnsignedInt32)((CIMValue)vector.elementAt(1)).getValue();
                    pICodMemInfoDataBean.m_onoffMemUnreturned = (UnsignedInt32)((CIMValue)vector.elementAt(2)).getValue();
                    pICodMemInfoDataBean.m_onoffMemDaysAvail = (UnsignedInt16)((CIMValue)vector.elementAt(3)).getValue();
                    pICodMemInfoDataBean.m_onoffRequestMemDaysLeft = (UnsignedInt16)((CIMValue)vector.elementAt(4)).getValue();
                    pICodMemInfoDataBean.m_onoffMemHoursLeft = (UnsignedInt8)((CIMValue)vector.elementAt(5)).getValue();
                    pICodMemInfoDataBean.m_onoffMemState = (UnsignedInt8)((CIMValue)vector.elementAt(6)).getValue();
                    pICodMemInfoDataBean.m_onoffMemUnit = (UnsignedInt16)((CIMValue)vector.elementAt(7)).getValue();
                } else {
                    pICodMemInfoDataBean.m_onoffMemActivated = (UnsignedInt32)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                    pICodMemInfoDataBean.m_onoffMemAvail = (UnsignedInt32)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                    pICodMemInfoDataBean.m_onoffMemUnreturned = (UnsignedInt32)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                    pICodMemInfoDataBean.m_onoffMemDaysAvail = (UnsignedInt16)((CIMProperty)vector.elementAt(3)).getValue().getValue();
                    pICodMemInfoDataBean.m_onoffRequestMemDaysLeft = (UnsignedInt16)((CIMProperty)vector.elementAt(4)).getValue().getValue();
                    pICodMemInfoDataBean.m_onoffMemHoursLeft = (UnsignedInt8)((CIMProperty)vector.elementAt(5)).getValue().getValue();
                    pICodMemInfoDataBean.m_onoffMemState = (UnsignedInt8)((CIMProperty)vector.elementAt(6)).getValue().getValue();
                    pICodMemInfoDataBean.m_onoffMemUnit = (UnsignedInt16)((CIMProperty)vector.elementAt(7)).getValue().getValue();
                }
            }
            if (hashSet.contains("activated_trial_mem") || hashSet.contains("unreturned_trial_mem") || hashSet.contains("mem_trial_state") || hashSet.contains("mem_trial_days_left") || hashSet.contains("mem_trial_hours_left")) {
                UnsignedInt16 unsignedInt16;
                vector2 = new Vector();
                vector = new Vector();
                PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetTrialCodMemoryInfo", vector2, vector);
                if (vector.elementAt(0) instanceof CIMValue) {
                    pICodMemInfoDataBean.m_trialMemActivated = (UnsignedInt32)((CIMValue)vector.elementAt(0)).getValue();
                    pICodMemInfoDataBean.m_trialMemUnreturned = (UnsignedInt32)((CIMValue)vector.elementAt(1)).getValue();
                    unsignedInt16 = (UnsignedInt16)((CIMValue)vector.elementAt(2)).getValue();
                    pICodMemInfoDataBean.m_trialMemState = (UnsignedInt8)((CIMValue)vector.elementAt(3)).getValue();
                } else {
                    pICodMemInfoDataBean.m_trialMemActivated = (UnsignedInt32)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                    pICodMemInfoDataBean.m_trialMemUnreturned = (UnsignedInt32)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                    unsignedInt16 = (UnsignedInt16)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                    pICodMemInfoDataBean.m_trialMemState = (UnsignedInt8)((CIMProperty)vector.elementAt(3)).getValue().getValue();
                }
                int n = unsignedInt16.intValue();
                pICodMemInfoDataBean.m_trialMemDaysLeft = new UnsignedInt16(n / 24);
                pICodMemInfoDataBean.m_trialMemHoursLeft = new UnsignedInt16(n % 24);
            }
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return pICodMemInfoDataBean;
    }

    public PIOnoffCodBillingInfoDataBean getOnoffCodProcBillingInfoDataBean() throws PIHscClientException {
        return this.getOnoffCodProcBillingInfoDataBean(PIOnoffCodBillingInfoDataBean.ALL_PROC_KEYS);
    }

    public PIOnoffCodBillingInfoDataBean getOnoffCodProcBillingInfoDataBean(String[] stringArray) throws PIHscClientException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        PIOnoffCodBillingInfoDataBean pIOnoffCodBillingInfoDataBean = new PIOnoffCodBillingInfoDataBean();
        try {
            int n;
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetOnoffCodProcBillingInfo", vector, vector2);
            Vector vector3 = null;
            if (vector2.elementAt(0) instanceof CIMValue) {
                n = ((UnsignedInt8)((CIMValue)vector2.elementAt(0)).getValue()).intValue();
                vector3 = (Vector)((CIMValue)vector2.elementAt(1)).getValue();
            } else {
                n = ((UnsignedInt8)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
                vector3 = (Vector)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
            }
            if (n == 1) {
                pIOnoffCodBillingInfoDataBean.m_sysType = (String)vector3.elementAt(0);
                pIOnoffCodBillingInfoDataBean.m_sysSerialNum = (String)vector3.elementAt(1);
                pIOnoffCodBillingInfoDataBean.m_anchorCardCcin = (String)vector3.elementAt(2);
                pIOnoffCodBillingInfoDataBean.m_anchorCardSerialNum = (String)vector3.elementAt(3);
                pIOnoffCodBillingInfoDataBean.m_anchorCardId = (String)vector3.elementAt(4);
                pIOnoffCodBillingInfoDataBean.m_enabled = (String)vector3.elementAt(5);
                pIOnoffCodBillingInfoDataBean.m_active = (String)vector3.elementAt(6);
                pIOnoffCodBillingInfoDataBean.m_resourceId = (String)vector3.elementAt(7);
                pIOnoffCodBillingInfoDataBean.m_histEnabledResourceDays = (String)vector3.elementAt(8);
                pIOnoffCodBillingInfoDataBean.m_sequenceNum = (String)vector3.elementAt(9);
                pIOnoffCodBillingInfoDataBean.m_entryChecksum = (String)vector3.elementAt(10);
                pIOnoffCodBillingInfoDataBean.m_activatedOnoffResources = (String)vector3.elementAt(11);
                pIOnoffCodBillingInfoDataBean.m_activatedResourceDays = (String)vector3.elementAt(12);
                pIOnoffCodBillingInfoDataBean.m_expiredResourceDays = (String)vector3.elementAt(13);
                pIOnoffCodBillingInfoDataBean.m_remainingResourceDays = (String)vector3.elementAt(14);
                pIOnoffCodBillingInfoDataBean.m_resourceDaysCounter = (String)vector3.elementAt(15);
                pIOnoffCodBillingInfoDataBean.m_availOnoffResources = (String)vector3.elementAt(16);
                pIOnoffCodBillingInfoDataBean.m_reserved1 = (String)vector3.elementAt(17);
                if (pIOnoffCodBillingInfoDataBean.m_reserved1 == null) {
                    pIOnoffCodBillingInfoDataBean.m_reserved1 = "";
                }
                pIOnoffCodBillingInfoDataBean.m_histExpiredResourceDays = (String)vector3.elementAt(18);
                pIOnoffCodBillingInfoDataBean.m_reserved2 = (String)vector3.elementAt(19);
                if (pIOnoffCodBillingInfoDataBean.m_reserved2 == null) {
                    pIOnoffCodBillingInfoDataBean.m_reserved2 = "";
                }
                pIOnoffCodBillingInfoDataBean.m_histUnreturnedResourceDays = (String)vector3.elementAt(20);
                pIOnoffCodBillingInfoDataBean.m_dateTime = (String)vector3.elementAt(21);
                pIOnoffCodBillingInfoDataBean.m_totalSysRunTimeHours = (String)vector3.elementAt(22);
                pIOnoffCodBillingInfoDataBean.m_signature = (String)vector3.elementAt(23);
                pIOnoffCodBillingInfoDataBean.m_entryCheck = (String)vector3.elementAt(24);
                pIOnoffCodBillingInfoDataBean.m_status = (String)vector3.elementAt(25);
                pIOnoffCodBillingInfoDataBean.m_reserved3 = (String)vector3.elementAt(26);
                if (pIOnoffCodBillingInfoDataBean.m_reserved3 == null) {
                    pIOnoffCodBillingInfoDataBean.m_reserved3 = "";
                }
                pIOnoffCodBillingInfoDataBean.m_date = (String)vector3.elementAt(27);
                pIOnoffCodBillingInfoDataBean.m_time = (String)vector3.elementAt(28);
            }
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return pIOnoffCodBillingInfoDataBean;
    }

    public PIOnoffCodBillingInfoDataBean getOnoffCodMemBillingInfoDataBean() throws PIHscClientException {
        return this.getOnoffCodMemBillingInfoDataBean(PIOnoffCodBillingInfoDataBean.ALL_MEM_KEYS);
    }

    public PIOnoffCodBillingInfoDataBean getOnoffCodMemBillingInfoDataBean(String[] stringArray) throws PIHscClientException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        PIOnoffCodBillingInfoDataBean pIOnoffCodBillingInfoDataBean = new PIOnoffCodBillingInfoDataBean();
        try {
            int n;
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetOnoffCodMemBillingInfo", vector, vector2);
            Vector vector3 = null;
            if (vector2.elementAt(0) instanceof CIMValue) {
                n = ((UnsignedInt8)((CIMValue)vector2.elementAt(0)).getValue()).intValue();
                vector3 = (Vector)((CIMValue)vector2.elementAt(1)).getValue();
            } else {
                n = ((UnsignedInt8)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
                vector3 = (Vector)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
            }
            if (n == 1) {
                pIOnoffCodBillingInfoDataBean.m_sysType = (String)vector3.elementAt(0);
                pIOnoffCodBillingInfoDataBean.m_sysSerialNum = (String)vector3.elementAt(1);
                pIOnoffCodBillingInfoDataBean.m_anchorCardCcin = (String)vector3.elementAt(2);
                pIOnoffCodBillingInfoDataBean.m_anchorCardSerialNum = (String)vector3.elementAt(3);
                pIOnoffCodBillingInfoDataBean.m_anchorCardId = (String)vector3.elementAt(4);
                pIOnoffCodBillingInfoDataBean.m_enabled = (String)vector3.elementAt(5);
                pIOnoffCodBillingInfoDataBean.m_active = (String)vector3.elementAt(6);
                pIOnoffCodBillingInfoDataBean.m_resourceId = (String)vector3.elementAt(7);
                pIOnoffCodBillingInfoDataBean.m_histEnabledResourceDays = (String)vector3.elementAt(8);
                pIOnoffCodBillingInfoDataBean.m_sequenceNum = (String)vector3.elementAt(9);
                pIOnoffCodBillingInfoDataBean.m_entryChecksum = (String)vector3.elementAt(10);
                pIOnoffCodBillingInfoDataBean.m_activatedOnoffResources = (String)vector3.elementAt(11);
                pIOnoffCodBillingInfoDataBean.m_activatedResourceDays = (String)vector3.elementAt(12);
                pIOnoffCodBillingInfoDataBean.m_expiredResourceDays = (String)vector3.elementAt(13);
                pIOnoffCodBillingInfoDataBean.m_remainingResourceDays = (String)vector3.elementAt(14);
                pIOnoffCodBillingInfoDataBean.m_resourceDaysCounter = (String)vector3.elementAt(15);
                pIOnoffCodBillingInfoDataBean.m_availOnoffResources = (String)vector3.elementAt(16);
                pIOnoffCodBillingInfoDataBean.m_reserved1 = (String)vector3.elementAt(17);
                if (pIOnoffCodBillingInfoDataBean.m_reserved1 == null) {
                    pIOnoffCodBillingInfoDataBean.m_reserved1 = "";
                }
                pIOnoffCodBillingInfoDataBean.m_histExpiredResourceDays = (String)vector3.elementAt(18);
                pIOnoffCodBillingInfoDataBean.m_reserved2 = (String)vector3.elementAt(19);
                if (pIOnoffCodBillingInfoDataBean.m_reserved2 == null) {
                    pIOnoffCodBillingInfoDataBean.m_reserved2 = "";
                }
                pIOnoffCodBillingInfoDataBean.m_histUnreturnedResourceDays = (String)vector3.elementAt(20);
                pIOnoffCodBillingInfoDataBean.m_dateTime = (String)vector3.elementAt(21);
                pIOnoffCodBillingInfoDataBean.m_totalSysRunTimeHours = (String)vector3.elementAt(22);
                pIOnoffCodBillingInfoDataBean.m_signature = (String)vector3.elementAt(23);
                pIOnoffCodBillingInfoDataBean.m_entryCheck = (String)vector3.elementAt(24);
                pIOnoffCodBillingInfoDataBean.m_status = (String)vector3.elementAt(25);
                pIOnoffCodBillingInfoDataBean.m_reserved3 = (String)vector3.elementAt(26);
                if (pIOnoffCodBillingInfoDataBean.m_reserved3 == null) {
                    pIOnoffCodBillingInfoDataBean.m_reserved3 = "";
                }
                pIOnoffCodBillingInfoDataBean.m_memUnitAdj = (String)vector3.elementAt(27);
                pIOnoffCodBillingInfoDataBean.m_date = (String)vector3.elementAt(28);
                pIOnoffCodBillingInfoDataBean.m_time = (String)vector3.elementAt(29);
            }
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return pIOnoffCodBillingInfoDataBean;
    }

    public PICodOrderInfoDataBean getCodOrderInfoDataBean(int n, int n2) throws PIHscClientException {
        return this.getCodOrderInfoDataBean(PICodOrderInfoDataBean.ALL_KEYS, n, n2);
    }

    public PICodOrderInfoDataBean getCodOrderInfoDataBean(String[] stringArray, int n, int n2) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        PICodOrderInfoDataBean pICodOrderInfoDataBean = new PICodOrderInfoDataBean();
        try {
            int n3;
            vector.addElement(new CIMProperty(MOF_COD_TYPE, new CIMValue((Object)new UnsignedInt8((short)n))));
            vector.addElement(new CIMProperty(MOF_RESOURCE_TYPE, new CIMValue((Object)new UnsignedInt8((short)n2))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetCodOrderInfo", vector, vector2);
            Vector vector3 = null;
            if (vector2.elementAt(0) instanceof CIMValue) {
                n3 = ((UnsignedInt8)((CIMValue)vector2.elementAt(0)).getValue()).intValue();
                vector3 = (Vector)((CIMValue)vector2.elementAt(1)).getValue();
            } else {
                n3 = ((UnsignedInt8)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
                vector3 = (Vector)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
            }
            if (n3 == 1) {
                pICodOrderInfoDataBean.m_sysType = (String)vector3.elementAt(0);
                pICodOrderInfoDataBean.m_sysSerialNum = (String)vector3.elementAt(1);
                pICodOrderInfoDataBean.m_anchorCardCcin = (String)vector3.elementAt(2);
                pICodOrderInfoDataBean.m_anchorCardSerialNum = (String)vector3.elementAt(3);
                pICodOrderInfoDataBean.m_anchorCardId = (String)vector3.elementAt(4);
                pICodOrderInfoDataBean.m_resourceId = (String)vector3.elementAt(5);
                pICodOrderInfoDataBean.m_activatedResources = (String)vector3.elementAt(6);
                pICodOrderInfoDataBean.m_sequenceNum = (String)vector3.elementAt(7);
                pICodOrderInfoDataBean.m_entryCheck = (String)vector3.elementAt(8);
            }
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return pICodOrderInfoDataBean;
    }

    public void manageOnOffProcessors(int n, int n2) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        int n3 = n * 100;
        int n4 = n2 * 24;
        try {
            vector.addElement(new CIMProperty(MOF_PROCESSOR_UNITS, new CIMValue((Object)new UnsignedInt32((long)((short)n3)))));
            vector.addElement(new CIMProperty(MOF_HOURS_TO_USE_PROCS, new CIMValue((Object)new UnsignedInt32((long)((short)n4)))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "ManageOnoffProcessors", vector, vector2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public void manageMeteredProcessors(int n) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        int n2 = n * 100;
        try {
            vector.addElement(new CIMProperty(MOF_PROCESSOR_UNITS, new CIMValue((Object)new UnsignedInt32((long)((short)n2)))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "ManageMeteredProcessors", vector, vector2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public void manageOnOffMemory(int n, int n2) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        int n3 = n2 * 24;
        try {
            vector.addElement(new CIMProperty(MOF_MEMORY_UNITS, new CIMValue((Object)new UnsignedInt32((long)((short)n)))));
            vector.addElement(new CIMProperty(MOF_HOURS_TO_USE_MEM, new CIMValue((Object)new UnsignedInt32((long)((short)n3)))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "ManageOnoffMemory", vector, vector2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public void disableTrialResources(int n) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            vector.addElement(new CIMProperty(MOF_RESOURCE_TYPE, new CIMValue((Object)new UnsignedInt8((short)n))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "DisableTrialResources", vector, vector2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public Vector getCodHistoryLog() throws PIHscClientException {
        return this.getCodHistoryLog(PICodHistLogEntryDataBean.ALL_KEYS);
    }

    public Vector getCodHistoryLog(String[] stringArray) throws PIHscClientException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector<PICodHistLogEntryDataBean> vector3 = new Vector<PICodHistLogEntryDataBean>();
        boolean bl = false;
        UnsignedInt16 unsignedInt16 = null;
        UnsignedInt8 unsignedInt8 = null;
        try {
            Vector vector4;
            Vector vector5;
            Vector vector6;
            Vector vector7;
            Vector vector8;
            Vector vector9;
            Vector vector10;
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetCodHistoryLog", vector, vector2);
            if (vector2.elementAt(0) instanceof CIMValue) {
                bl = true;
            }
            if (bl) {
                unsignedInt8 = (UnsignedInt8)((CIMValue)vector2.elementAt(0)).getValue();
                unsignedInt16 = (UnsignedInt16)((CIMValue)vector2.elementAt(1)).getValue();
                vector10 = (Vector)((CIMValue)vector2.elementAt(2)).getValue();
                vector9 = (Vector)((CIMValue)vector2.elementAt(3)).getValue();
                vector8 = (Vector)((CIMValue)vector2.elementAt(4)).getValue();
                vector7 = (Vector)((CIMValue)vector2.elementAt(5)).getValue();
                vector6 = (Vector)((CIMValue)vector2.elementAt(6)).getValue();
                vector5 = (Vector)((CIMValue)vector2.elementAt(7)).getValue();
                vector4 = (Vector)((CIMValue)vector2.elementAt(8)).getValue();
            } else {
                unsignedInt8 = (UnsignedInt8)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                unsignedInt16 = (UnsignedInt16)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                vector10 = (Vector)((CIMProperty)vector2.elementAt(2)).getValue().getValue();
                vector9 = (Vector)((CIMProperty)vector2.elementAt(3)).getValue().getValue();
                vector8 = (Vector)((CIMProperty)vector2.elementAt(4)).getValue().getValue();
                vector7 = (Vector)((CIMProperty)vector2.elementAt(5)).getValue().getValue();
                vector6 = (Vector)((CIMProperty)vector2.elementAt(6)).getValue().getValue();
                vector5 = (Vector)((CIMProperty)vector2.elementAt(7)).getValue().getValue();
                vector4 = (Vector)((CIMProperty)vector2.elementAt(8)).getValue().getValue();
            }
            PICodHistLogEntryDataBean[] pICodHistLogEntryDataBeanArray = new PICodHistLogEntryDataBean[unsignedInt16.intValue()];
            for (int i = 0; i < unsignedInt16.intValue(); ++i) {
                pICodHistLogEntryDataBeanArray[i] = new PICodHistLogEntryDataBean();
                pICodHistLogEntryDataBeanArray[i].m_logEntryText = (String)vector10.elementAt(i);
                pICodHistLogEntryDataBeanArray[i].m_logEntryTimestampYear = (UnsignedInt16)vector9.elementAt(i);
                pICodHistLogEntryDataBeanArray[i].m_logEntryTimestampMonth = (UnsignedInt8)vector8.elementAt(i);
                pICodHistLogEntryDataBeanArray[i].m_logEntryTimestampDay = (UnsignedInt8)vector7.elementAt(i);
                pICodHistLogEntryDataBeanArray[i].m_logEntryTimestampHour = (UnsignedInt8)vector6.elementAt(i);
                pICodHistLogEntryDataBeanArray[i].m_logEntryTimestampMinute = (UnsignedInt8)vector5.elementAt(i);
                pICodHistLogEntryDataBeanArray[i].m_logEntryTimestampSecond = (UnsignedInt8)vector4.elementAt(i);
                pICodHistLogEntryDataBeanArray[i].m_logWrapVal = unsignedInt8;
                vector3.addElement(pICodHistLogEntryDataBeanArray[i]);
            }
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return vector3;
    }

    public BitSet getCodCapabilities() throws PIHscClientException {
        BitSet bitSet;
        UnsignedInt32 unsignedInt32;
        Object object;
        try {
            object = PIHscUtil.getCIMInstance(this.mHostName, this.mObjectPath, false);
            unsignedInt32 = (UnsignedInt32)PIHscUtil.getCIMAttrValue(object, "CodCapabilities");
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        if (IDebug.enabled) {
            System.err.println("COD Capabilities " + unsignedInt32);
        }
        if (unsignedInt32 != null) {
            object = new byte[]{unsignedInt32.byteValue()};
            bitSet = ByteUtilities.byteArrayToBitSet((byte[])object);
            if (IDebug.enabled) {
                System.err.println("BITSET: COD Capabilities " + bitSet);
            }
        } else {
            bitSet = new BitSet();
        }
        return bitSet;
    }

    public Hashtable getActivationIncrements() throws PIHscClientException {
        UnsignedInt16 unsignedInt16;
        UnsignedInt16 unsignedInt162;
        UnsignedInt16 unsignedInt163;
        Hashtable<String, UnsignedInt16> hashtable = new Hashtable<String, UnsignedInt16>();
        try {
            CIMInstance cIMInstance = PIHscUtil.getCIMInstance(this.mHostName, this.mObjectPath, false);
            unsignedInt163 = (UnsignedInt16)PIHscUtil.getCIMAttrValue(cIMInstance, "OnoffCodProcIncrement");
            unsignedInt162 = (UnsignedInt16)PIHscUtil.getCIMAttrValue(cIMInstance, "MeteredCodProcIncrement");
            unsignedInt16 = (UnsignedInt16)PIHscUtil.getCIMAttrValue(cIMInstance, "OnoffCodMemIncrement");
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        hashtable.put(ONOFF_PROC_INCREMENT, unsignedInt163);
        hashtable.put(METERED_PROC_INCREMENT, unsignedInt162);
        hashtable.put(ONOFF_MEM_INCREMENT, unsignedInt16);
        return hashtable;
    }

    public PICodKeyDataBean setCodKey(String string) throws PIHscClientException {
        return this.setCodKey(255, 0, string);
    }

    public PICodKeyDataBean setCodKey(int n, int n2, String string) throws PIHscClientException {
        PICodKeyDataBean pICodKeyDataBean = new PICodKeyDataBean();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            vector.addElement(new CIMProperty(MOF_CONFIRMATION_PARM, new CIMValue((Object)new UnsignedInt8((short)n))));
            vector.addElement(new CIMProperty(MOF_CONFIRMATION_ID, new CIMValue((Object)new UnsignedInt16((int)((short)n2)))));
            vector.addElement(new CIMProperty(MOF_COD_KEY, new CIMValue((Object)string)));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "SetCodKey", vector, vector2);
            if (vector2.elementAt(0) instanceof CIMValue) {
                pICodKeyDataBean.setProcsToActivate((UnsignedInt32)((CIMValue)vector2.elementAt(0)).getValue());
                pICodKeyDataBean.setMemToActivate((UnsignedInt32)((CIMValue)vector2.elementAt(1)).getValue());
                pICodKeyDataBean.setDaysToActivateEnable((UnsignedInt16)((CIMValue)vector2.elementAt(2)).getValue());
                pICodKeyDataBean.setCodType((UnsignedInt8)((CIMValue)vector2.elementAt(3)).getValue());
                pICodKeyDataBean.setResourceType((UnsignedInt8)((CIMValue)vector2.elementAt(4)).getValue());
                pICodKeyDataBean.setEnableDisable((UnsignedInt8)((CIMValue)vector2.elementAt(5)).getValue());
                pICodKeyDataBean.setConfirmNeeded((Boolean)((CIMValue)vector2.elementAt(6)).getValue());
                pICodKeyDataBean.setConfirmMsgID((UnsignedInt16)((CIMValue)vector2.elementAt(7)).getValue());
                pICodKeyDataBean.setReturnMessage((String)((CIMValue)vector2.elementAt(8)).getValue());
                pICodKeyDataBean.setCodeCompleteSuccess((Boolean)((CIMValue)vector2.elementAt(9)).getValue());
            } else {
                pICodKeyDataBean.setProcsToActivate((UnsignedInt32)((CIMProperty)vector2.elementAt(0)).getValue().getValue());
                pICodKeyDataBean.setMemToActivate((UnsignedInt32)((CIMProperty)vector2.elementAt(1)).getValue().getValue());
                pICodKeyDataBean.setDaysToActivateEnable((UnsignedInt16)((CIMProperty)vector2.elementAt(2)).getValue().getValue());
                pICodKeyDataBean.setCodType((UnsignedInt8)((CIMProperty)vector2.elementAt(3)).getValue().getValue());
                pICodKeyDataBean.setResourceType((UnsignedInt8)((CIMProperty)vector2.elementAt(4)).getValue().getValue());
                pICodKeyDataBean.setEnableDisable((UnsignedInt8)((CIMProperty)vector2.elementAt(5)).getValue().getValue());
                pICodKeyDataBean.setConfirmNeeded((Boolean)((CIMProperty)vector2.elementAt(6)).getValue().getValue());
                pICodKeyDataBean.setConfirmMsgID((UnsignedInt16)((CIMProperty)vector2.elementAt(7)).getValue().getValue());
                pICodKeyDataBean.setReturnMessage((String)((CIMProperty)vector2.elementAt(8)).getValue().getValue());
                pICodKeyDataBean.setCodeCompleteSuccess((Boolean)((CIMProperty)vector2.elementAt(9)).getValue().getValue());
            }
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return pICodKeyDataBean;
    }

    public PISharedProcPoolUtilizationDataBean getSharedProcPoolUtilizationDataBean() throws PIHscClientException {
        return this.getSharedProcPoolUtilizationDataBean(PISharedProcPoolUtilizationDataBean.ALL_KEYS);
    }

    public PISharedProcPoolUtilizationDataBean getSharedProcPoolUtilizationDataBean(String[] stringArray) throws PIHscClientException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        UnsignedInt32 unsignedInt32 = null;
        UnsignedInt32 unsignedInt322 = null;
        UnsignedInt16 unsignedInt16 = null;
        UnsignedInt16 unsignedInt162 = null;
        UnsignedInt16 unsignedInt163 = null;
        UnsignedInt16 unsignedInt164 = null;
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt8 unsignedInt82 = null;
        UnsignedInt8 unsignedInt83 = null;
        UnsignedInt8 unsignedInt84 = null;
        UnsignedInt8 unsignedInt85 = null;
        PISharedProcPoolUtilizationDataBean pISharedProcPoolUtilizationDataBean = new PISharedProcPoolUtilizationDataBean();
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetSharedProcessorPoolUtilization", vector, vector2);
            if (vector2.elementAt(0) instanceof CIMValue) {
                unsignedInt32 = (UnsignedInt32)((CIMValue)vector2.elementAt(0)).getValue();
                unsignedInt322 = (UnsignedInt32)((CIMValue)vector2.elementAt(1)).getValue();
                unsignedInt16 = (UnsignedInt16)((CIMValue)vector2.elementAt(2)).getValue();
                unsignedInt162 = (UnsignedInt16)((CIMValue)vector2.elementAt(3)).getValue();
                unsignedInt163 = (UnsignedInt16)((CIMValue)vector2.elementAt(4)).getValue();
                unsignedInt164 = (UnsignedInt16)((CIMValue)vector2.elementAt(5)).getValue();
                unsignedInt8 = (UnsignedInt8)((CIMValue)vector2.elementAt(6)).getValue();
                unsignedInt82 = (UnsignedInt8)((CIMValue)vector2.elementAt(7)).getValue();
                unsignedInt83 = (UnsignedInt8)((CIMValue)vector2.elementAt(8)).getValue();
                unsignedInt84 = (UnsignedInt8)((CIMValue)vector2.elementAt(9)).getValue();
                unsignedInt85 = (UnsignedInt8)((CIMValue)vector2.elementAt(10)).getValue();
            } else {
                unsignedInt32 = (UnsignedInt32)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                unsignedInt322 = (UnsignedInt32)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                unsignedInt16 = (UnsignedInt16)((CIMProperty)vector2.elementAt(2)).getValue().getValue();
                unsignedInt162 = (UnsignedInt16)((CIMProperty)vector2.elementAt(3)).getValue().getValue();
                unsignedInt163 = (UnsignedInt16)((CIMProperty)vector2.elementAt(4)).getValue().getValue();
                unsignedInt164 = (UnsignedInt16)((CIMProperty)vector2.elementAt(5)).getValue().getValue();
                unsignedInt8 = (UnsignedInt8)((CIMProperty)vector2.elementAt(6)).getValue().getValue();
                unsignedInt82 = (UnsignedInt8)((CIMProperty)vector2.elementAt(7)).getValue().getValue();
                unsignedInt83 = (UnsignedInt8)((CIMProperty)vector2.elementAt(8)).getValue().getValue();
                unsignedInt84 = (UnsignedInt8)((CIMProperty)vector2.elementAt(9)).getValue().getValue();
                unsignedInt85 = (UnsignedInt8)((CIMProperty)vector2.elementAt(10)).getValue().getValue();
            }
            pISharedProcPoolUtilizationDataBean.m_nonReserveProcs = new UnsignedInt32(unsignedInt32.longValue() / 100L);
            pISharedProcPoolUtilizationDataBean.m_meteredProcs = new UnsignedInt32(unsignedInt322.longValue() / 100L);
            pISharedProcPoolUtilizationDataBean.m_nonReserveProcsUtilization = new UnsignedInt16(unsignedInt16.intValue() / 100);
            pISharedProcPoolUtilizationDataBean.m_meteredProcsUtilization = new UnsignedInt16(unsignedInt162.intValue() / 100);
            pISharedProcPoolUtilizationDataBean.m_sampleRate = unsignedInt163;
            pISharedProcPoolUtilizationDataBean.m_timestampYear = unsignedInt164;
            pISharedProcPoolUtilizationDataBean.m_timestampMonth = unsignedInt8;
            pISharedProcPoolUtilizationDataBean.m_timestampDay = unsignedInt82;
            pISharedProcPoolUtilizationDataBean.m_timestampHour = unsignedInt83;
            pISharedProcPoolUtilizationDataBean.m_timestampMinute = unsignedInt84;
            pISharedProcPoolUtilizationDataBean.m_timestampSeconds = unsignedInt85;
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return pISharedProcPoolUtilizationDataBean;
    }

    public void setCoDRecovery(int n) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            vector.addElement(new CIMProperty(MOF_COD_RECOVERY_COMPLETE_VALUE, new CIMValue((Object)new UnsignedInt8((short)((byte)n)))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "SetCodRecoveryComplete", vector, vector2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    static {
        Properties properties = new Properties();
        int n = 300;
        try {
            properties.load(new FileInputStream(TIMEOUT_PROPS_FILE));
            String string = properties.getProperty(TIMEOUT_KEY);
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        COD_KEY_ASYNC_TIMEOUT_SEC = n;
    }
}

